function qnew = updateFSA(FSA,s,q)
%function sequentially updates the FSA and return the sequence of discrete
%states
%qnew = updateFSA(FSA,s,q)
%inputs:
%FSA = finite state automata imported from UMDES
%s = string of events
%q = current FSA state
qnew = [];
qc = q;
for i = 1:length(s)
    for j = 1:length(FSA)
        qc(j) = executeEvents(FSA{j},s(i),qc(j));
    end
    qnew = [qnew qc];
end