function [Irc,Isc,wr,Tm] = ssTurbine(x,p)
%[Ir,wr] = ssTurbine(t,x,z,p)
%p = [Xs Xm Xr Rs Rr ws]
%x = [P V2R V2I]

Xs = p(1);
Xm = p(2);
Xr = p(3);
Rs = p(4);
Rr = p(5);
ws = p(6);


P = x(1);
V2R = x(2);
V2I = x(3);
V2 = V2R + 1i*V2I;

%analytically compute wr (reduces to quadratic equation)
V2s = V2R^2 + V2I^2;
pol = [((P*(Rs^2 + Xs^2))/V2s - Rs),(Xm^2 - (2*P*Rs*Xm^2)/V2s),(P*(Rs^2*Xr^2 + Xm^4 - 2*Xm^2*Xr*Xs + Xr^2*Xs^2))/V2s - Rs*Xr^2];
a = max(roots(pol));
wr = ws*(Rr + a)/a;
if imag(roots(pol))~=0
    error('injection not feasible')
end


%compute Is and Ir by substitution
fr = ((a - 1i*Xr)*(Rs+1i*Xs) - Xm^2)/(1i*Xm);
fs = (a - 1i*Xr)/(1i*Xm);
Ir = V2/fr;
Is = Ir*fs;
Tm = -imag(Is*conj(Is*Xs/ws + Ir*Xm/ws));

Irc = [real(Ir) imag(Ir)];
Isc = [real(Is) imag(Is)];







