function [Jx,Jd] = jTurbine(t,x,d,z,p)
%p = [Xs Xm Xr Rs Rr ws Jg Tm]
%x = [IsR IsI IrR IrI wr V2R V2I]
%residual equation system
% f1 = -V2 + Is*(Rs + Xs*1i) + Ir*1i*Xm;
% f2 = Is*1i*Xm + Ir*1i*Xr - Ir*Rr/(wr/ws - 1);
% f3 = Is*conj(Is*Xs/ws + Ir*Xm/ws);
% r(1) = real(f1);
% r(2) = imag(f1);
% r(3) = real(f2);
% r(4) = imag(f2);
% r(5) = Tm + imag(f3) - d(5)*Jg;


Xs = p(1);
Xm = p(2);
Xr = p(3); 
Rs = p(4); 
Rr = p(5); 
ws = p(6); 
Jg = p(7); 
Tm = p(8);

IsR = x(1); 
IsI = x(2);
IrR = x(3);
IrI = x(4);
wr = x(5); 
V2R = x(6); 
V2I = x(7);

V2 = V2R + V2I*1i;
Is = IsR + IsI*1i;
Ir = IrR + IrI*1i;

dr1 = zeros(1,7);
dr2 = zeros(1,7);
dr3 = zeros(1,7);

dr1(1:2) = (Rs + Xs*1i)*[1 1i];
dr1(3:4) = 1i*Xm*[1 1i];
dr1(6:7) = -1*[1 1i];
dr2(1:2) = 1i*Xm*[1 1i];
dr2(3:4) = (1i*Xr - Rr/(wr/ws - 1))*[1 1i];
dr2(5) = Ir*Rr*(wr/ws - 1)^(-2)/ws;
dr3(1:2) = conj(Is*Xs/ws + Ir*Xm/ws)*[1 1i] + Is*Xs/ws*[1 -1i];
dr3(3:4) = Is*Xm/ws*[1 -1i];

Jx = zeros(5,7);
Jx(1,:) = real(dr1);
Jx(2,:) = imag(dr1);
Jx(3,:) = real(dr2);
Jx(4,:) = imag(dr2);
Jx(5,:) = imag(dr3);


Jd = zeros(5,7);
Jd(5,5) = -Jg;
