function [Jx,Jd] = jNetwork(t,x,d,z,p)
%network Jacobian function
%residual equation system:
%   f1 = z*(V0 - z*V2)/Z1 - Is - (Ic + (V2 - V3)/Z2);
%   f2 = Pd + Qd*1i - conj(V2 - V3)/conj(Z2)*V3;
%   r(1) = real(f1);
%   r(2) = imag(f1);
%   r(3) = real(f2);
%   r(4) = imag(f2);
%   r(5) = d(1);
%   r(6) = d(2);
%inputs:
%t = time
%x = [V0R V0I V2R V2I V3R V3I Pd Qd IsR IsI IcR IcI]
%d = dx/dt
%z = [nT nTq]
%p = [X1 X2 Vm Vp nm np ns]




X1 = p(1);
X2 = p(2);
n = z(1);

V0R = x(1);
V0I = x(2);
V2R = x(3);
V2I = x(4);
V3R = x(5); 
V3I = x(6); 
Pd = x(7);
Qd = x(8);
IsR = x(9); 
IsI = x(10); 
IcR = x(11); 
IcI = x(12);

V0 = V0R + V0I*1i;
V2 = V2R + V2I*1i;
V3 = V3R + V3I*1i;
Is = IsR + IsI*1i;
Ic = IcR + IcI*1i;
Z1 = 1i*X1;
Z2 = 1i*X2;

dr1 = zeros(1,12);
dr1(1:2) = n/Z1*[1 1i]; dr1(3:4) = (-n^2/Z1-1/Z2)*[1 1i]; 
dr1(5:6) = 1/Z2*[1 1i]; dr1(9:10) = -[1 1i]; dr1(11:12) = -[1 1i];
dr2 = zeros(1,12);
dr2(3:4) = -V3/conj(Z2)*[1 -1i]; dr2(5:6) = 1/conj(Z2)*([1 -1i]*V3-conj(V2-V3)*[1 1i]);
dr2(7:8) = [1 1i];

Jx = zeros(6,12);
Jx(1,:) = real(dr1);
Jx(2,:) = imag(dr1);
Jx(3,:) = real(dr2);
Jx(4,:) = imag(dr2);
Jd = zeros(6,12);
Jd(5:6,1:2) = eye(2); 




