function [Jx,Jd] = jCapacitor(t,x,d,z,p)
%p = [C nCT]
%z = [nC nCq]
%x = [IcR IcI V2R V2I]
%residual equation system
% f1 = Ic - V2*A;
% r(1) = real(f1);
% r(2) = imag(f1);

C = p(1);
nC = z(1);

IcR = x(1); 
IcI = x(2);
V2R = x(3); 
V2I = x(4);

V2 = V2R + V2I*1i;
Ic = IcR + IcI*1i;
A = 1i*C*nC;

Jx = zeros(2,4);
dr1 = zeros(1,4);
dr1(1:2) = [1 1i]; 
dr1(3:4) = -A*[1 1i];
Jx(1,:) = real(dr1);
Jx(2,:) = imag(dr1);

Jd = zeros(2,4);