function [x1,d1,ec] = instantChange(x0,d0,z0,p0,z1,p1,St,Co,fnames,xalg,oevents,options)
%computes the instantanous events and state resets that occured when
%parameters change
%[x1,d1,ec] = instantChange(x0,d0,z0,p0,z1,p1,St,Co,fnames,xalg,oevents,options)
%inputs:
%x0 = current state
%d0 = current state derivative
%z0 = current dynamic parameter
%p0 = current static parameter
%z1 = new dynamic parameter
%p1 = new static parameter
%St = state strucutre (see getNetworkPars)
%Co = module connectivity matrix (see getNetworkPars)
%fnames = module ode, jacobian, event function handles (see getNetworkPars)
%xalg = array of continuous states (see getNetworkPars)
%oevents = array of observable events (see getNetworkPars)
%options = odesolver options

[val0,~,dir] = efun(0,x0,d0,z0,p0,St,fnames,length(oevents));
[x1,d1] = decic(@(t,x,d)odefun(t,x,d,z1,p1,St,Co,fnames),0,x0,xalg,d0,zeros(size(d0)),options);
val1 = efun(0,x1,d1,z1,p1,St,fnames,length(oevents));
ec = oevents(val0.*val1 <= 0 & sign(val1 - val0) == dir);