function [x0,d0,p0,z0] = getNetworkX0(P2,p0,z0,St,Co,fnames,oevents)
%====compute the nominal state using load flow and analytic solutions====
%provide the measured injections at nodes 2 and 3, here we assume reactive
%power injections are zero at both nodes (however, this is not necessary)
P3 = p0{4}(2); %p{4}(2) = Ps, the steady state power consumed by load
%solve the network voltages given the injections, flat start is used as an initial
%guess
Vn = fsolve(@(x)loadFlow(x,[P2 P3],z0{1},p0{1}),[1 0 1 0],optimoptions('fsolve','Jacobian','on','tolx',1e-12,'tolfun',1e-6,'display','off'));
%next compute the states of all other modules
%solve for the steady state load states
[xd,Pd,Qd] = ssLoad(Vn(3:4),p0{4});
%solve the steady state turbine for given network state and real power
%injection
[Ir,Is,wr,Tm] = ssTurbine([P2 Vn(1:2)],p0{6});
%solve the capacitor current and connection coefficient to balance the
%turbine reactive power demand
Qtu = -Vn(1)*Is(2) + Vn(2)*Is(1); %reactive power consumed by the turbine
[Ic,nC] = ssCapacitor([-Qtu Vn(1:2)],p0{5});
%adjust static parameters that are not really known a priori
z0{5} = [nC nC]; %number of capacitors connected at nominal state
p0{6}(8) = Tm; %torque on the turbine
%construct the system state from the module states
x0lf = [1 0 Vn Pd Qd Is Ic 0 0 0 0 xd Pd Qd Vn(3:4) Ic Vn(1:2) Is Ir wr Vn(1:2)];

options = odeset('Jacobian',@(t,x,d)jfun(t,x,d,z0,p0,St,Co,fnames),'events',@(t,x,d)efun(t,x,d,z0,p0,St,fnames,length(oevents)));

[x0,d0] = decic(@(t,x,d)odefun(t,x,d,z0,p0,St,Co,fnames),0,x0lf,zeros(1,St(end)),zeros(1,St(end)),zeros(1,St(end)),options);