function [p,z0,St,Co,fnames,stypes,oevents,FSA,FSAsup] = getNetworkPars
%[xsol,dsol,r,Jx,Jd,val,ter,dir,p,z0,St,Co,fnames,stypes,options] = getNetworkPars_v1
%INPUTS: 
%   none
%OUTPUTS: 
%   p: static parameter cell array
%   z0: dynamic parameter cell array
%   St: 
%DESCRIPTION OF PARAMETER VECTOR:
% p{1} = [X1 X2 Vm Vp nsT Qm Qp nsC];
% p{2} = [tauT];
% p{3} = [tauC];
% p{4} = [Tp Ps Pt];
% p{5} = [C nCT];
% p{6} = [Xs Xm Xr Rs Rr ws Jg Tm];
%DESCRIPTION OF CONTINUOUS STATE VECTOR
% x0{1} = [V0R V0I V2R V2I V3R V3I Pd Qd IsR IsI IcR IcI];
% x0{2} = [xTT yTT];
% x0{3} = [xTC yTC];
% x0{4} = [xd Pd Qd V3R V3I];
% x0{5} = [IcR IcI V2R V2I];
% x0{6} = [IsR IsI IrR IrI wr V2R V2I];
%DESCRIPTION OF DISCRETE SYSTEM STATE VECTOR
% z0{1} = [nT nTq];
% z0{2} = [tresT onT];
% z0{3} = [tresC onC];
% z0{4} = [];
% z0{5} = [nC nCq];
% z0{6} = [];

%PHYSICAL MEANING OF ALL OF THE ABOVE QUANTITIES AND MODULES
%MODULE 1: [network with voltmeter]
%-parameters
%   (V0R, V0I) = real and imaginary parts of voltage phasor at base node
%   (X1,X2) = line impedences
%   Vm = minimum voltage at node 2
%   Vp = maximum voltage at node 2
%   Qm = minimum reactive power at node 2
%   Qp = maximum reactive power at node 2
%   nsT = tap step size
%-continous states
%   (V2R,V2I) = real and imaginary parts of voltage phasor at node 2
%   (V3R,V3I) = real and imaginary parts of voltage phasor at node 3
%   (Pd,Qd) = active and reactive load power consumption
%   (IsR,IsI) = wind current consumption, real and imaginary stator currents
%   (IcR,IcI) = capacitor current consumptions, real and imaginary parts
%-discrete states
%   nT = current tap position
%   nTq = requested tap position
%MODULE 2: [timer for tap changer]
%-parameters
%   tauT = timer stop time
%-continous states
%   xTT = total timer on time 
%   yTT = time elapsed since last reset
%-discrete states
%   tresT = time of last reset
%   onT = timer setting (1 = timer on, 0 = timer off)
%MODULE 3: [timer for capacitor bank]
%-parameters
%   tauC = timer stop time
%-continous states
%   xTC = total timer on time 
%   yTC = time elapsed since last reset
%-discrete states
%   tresC = time of last reset
%   onC = timer setting (1 = timer on, 0 = timer off)
%MODULE 4: [load]
%-parameters
%   Tp = load recovery time constant
%   Ps = steady state power demand
%   Pt = load perturbation factor 
%-continous states
%   xd = load demand state
%   Pd = load power demand
%   (V3R,V3I) = node two real and imaginary voltages
%-discrete states
%   no discrete states
%MODULE 5: [capacitor bank]
%-parameters
%   C = capacitance of a single capacitor
%   nCT = number of capacitors in bank
%-continuous states
%   (IcR,IcI) = current injection from capacitor bank
%   (V2R,V2I) = real and imaginary parts of voltage phasor at node 2
%-discrete states
%   nC = number of connected capacitors
%   nCq = requested capacitor position
%MODULE 6: [wind turbine]
%-parameters
%   Xs = stator impedance
%   Xm = mutual impedance
%   Xr = rotor impedance
%   Rs = stator resistance
%   Rr = rotor resistance
%   ws = stator frequency
%   Jg = gear box and turbine rotational inertia
%   Tm = mechanical torque from turbine
%-continuous states
%   (IsR,IsI) = wind current injection, real and imaginary stator currents
%   (IrR,IrI) = real and imaginary rotor currents
%   wr = rotor rotational frequency
%   (V2R,V2I) = real and imaginary parts of voltage phasor at node 2
%-discrete states
%   no discrete states


%specify parameter values [do not change]
Ptu = 5;
Ps = 3;


X1 = 0.03; 
X2 = .05; 
Vm = .98;
Vp = 1.02;
Qm = -.25;
Qp = .25;
nsT = 0.025;
nsC = .2;
tauT = .5;
tauC = .5;
Tp = 5;

Pt = .4;
C = 3.4/2;
nCT = 5;
Xs = .0742;
Xm = .27626;
Xr = .1761;
Rs = .00121;
Rr = .04;
ws = 1;
Jg = 16;
Tm = 4.2000; %this will be corrected when computing initial state

%specify initial discrete states
nT = 1;
tresT = 0;
onT = 0;
tresC = 0;
onC = 0;
nC = 7.2835; %this will be corrected when computing initial state


%collect all values into cell arrays
p{1} = [X1 X2 Vm Vp nsT Qm Qp nsC];
p{2} = [tauT];
p{3} = [tauC];
p{4} = [Tp Ps Pt];
p{5} = [C nCT];
p{6} = [Xs Xm Xr Rs Rr ws Jg Tm];

z0{1} = [nT nT];
z0{2} = [tresT onT];
z0{3} = [tresC onC];
z0{4} = [];
z0{5} = [nC nC];
z0{6} = [];

%state cell array includes state names to allow automatic module
%interconnection

xst{1,1} = {'V0R' 'V0I' 'V2R' 'V2I' 'V3R' 'V3I' 'Pd' 'Qd' 'IsR' 'IsI' 'IcR' 'IcI'};
xst{1,2} = {'C' 'C' 'A' 'A' 'A' 'A' 'A' 'A' 'A' 'A' 'A' 'A'};
xst{2,1} = {'xTT' 'yTT'};
xst{2,2} = {'C' 'A'};
xst{3,1} = {'xTC' 'yTC'};
xst{3,2} = {'C' 'A'};
xst{4,1} = {'xd' 'Pd' 'Qd' 'V3R' 'V3I'};
xst{4,2} = {'C' 'A' 'A' 'A' 'A'};
xst{5,1} = {'IcR' 'IcI' 'V2R' 'V2I'};
xst{5,2} = {'A' 'A' 'A' 'A'};
xst{6,1} = {'IsR' 'IsI' 'IrR' 'IrI' 'wr' 'V2R' 'V2I'};
xst{6,2} = {'A' 'A' 'A' 'A' 'C' 'A' 'A'};


%compute modular state structure from state array x
[St, Co, stypes] = StateStructure(xst);


%specify ode, jacobian, event function handles
fnames = ...
    {@dNetwork @eNetwork @jNetwork;...
    @dTimerT @eTimerT @jTimerT;...
    @dTimerC @eTimerC @jTimerC;...
    @dLoad '' @jLoad;...
    @dCapacitor '' @jCapacitor;...
    @dTurbine '' @jTurbine};

%define system events
events{1} = {'vm','vp','vn','qm','qp','qn'};
events{2} = {'ttstop'};
events{3} = {'tcstop'};
events{4} = {};
events{5} = {};
events{6} = {};
%reorganize system events into a single cell array
oevents = [];
for i = 1:length(events)
    oevents = [oevents events{i}];
end
%define supervisor events


FSAsup{1} = UMDES2MATLAB('T_6sup'); %supervisor for tap changer
FSAsup{2} = UMDES2MATLAB('C_6sup'); %supervisor for capacitor bank
FSA{1} = UMDES2MATLAB('T_sensor');
FSA{2} = UMDES2MATLAB('T_switch');
FSA{3} = UMDES2MATLAB('T_timer');
FSA{4} = UMDES2MATLAB('C_sensor');
FSA{5} = UMDES2MATLAB('C_switch');
FSA{6} = UMDES2MATLAB('C_timer');










