function q1 = executeEvents(varargin)
%q1 = executeEvents(FSA,s,q0,E)
%INPUTS:
%FSA = FSA cell array
%s = cell array represing the string of events
%q0 = initial state
%E = FSA event set
%OUTPUTS:
%q1 = final state.  If string is infeasible, q1 is empty
FSA = varargin{1};
s = varargin{2};
q0 = varargin{3};

ne = length(s);

q1 = q0;
if nargin == 3
    E = [];
    for i = 1:length(FSA)
        E = union(E,FSA(i).events);
    end
else
    E = varargin{4};
end

for i = 1:ne
    if ~isempty(s{i})&&sum(strcmp(E,s{i}))
        q1 = FSA(q0).ter(strcmp(FSA(q0).events,s{i}));
        if isempty(q1)
            break
        else
            q0 = q1;
        end
    end
end
