function [valSystem,terSystem,dirSystem] = efun(t,x,d,z,p,St,fnames,nEv)
%system event function
%z = vector of discrete states
%p = vector of parameter values
%St = assignment of states to modules
%fnames = names of residual, etc. functions
%nEv = number of events
%modules: 
%   - module 1: core network
%   - module 2: timer transformer
%   - module 3: timer capacitor
%   - module 4: load
%   - module 5: capacitor bank
%   - module 6: wind turbine

nMo = size(St,1);
valSystem = zeros(nEv,1);
terSystem = zeros(nEv,1);
dirSystem = zeros(nEv,1);
ni = 0;
for i = 1:nMo
    if ~isempty(fnames{i,2})>0
        xCur = x(St(i,1):St(i,2));
        dCur = d(St(i,1):St(i,2));
        [valCur,terCur,dirCur] = fnames{i,2}(t,xCur,dCur,z{i},p{i});
        nCur = size(valCur,1);
        valSystem(ni+1:ni+nCur,:) = valCur;
        terSystem(ni+1:ni+nCur,:) = terCur;
        dirSystem(ni+1:ni+nCur,:) = dirCur;
        ni = ni + nCur;
    end
end


    


