function [val,ter,dir] = eNetwork(~,x,~,~,p)
%events:
%e1 = voltage drops below Vm
%e2 = voltage rises above Vp
%e3 = voltage returns to normal
%e4 = reactive power error drops below Qm
%e5 = reactive power error rises above Qp
%e6 = reactive power error returns to normal
%-parameter vector
% p{1} = [X1 X2 Vm Vp ns Qm Qp];


Vm = p(3);
Vp = p(4);
Qm = p(6);
Qp = p(7);

V2R = x(3);
V2I = x(4);

IsR = x(9); 
IsI = x(10); 
IcR = x(11); 
IcI = x(12);

V2 = V2R + V2I*1i;
Is = IsR + IsI*1i;
Ic = IcR + IcI*1i;

V2n = norm(V2);
Qs = imag(V2*conj(Is));
Qc = imag(V2*conj(Ic));
Qerr = Qs + Qc;



val = zeros(6,1);
dir = zeros(6,1);
ter = ones(6,1);

val(1) = V2n - Vm; %voltage drops below Vm
dir(1) = -1;
val(2) = Vp - V2n; %voltage rises above Vp
dir(2) = -1;
val(3) = (V2n - Vm)*(Vp - V2n); %voltage returns to normal
dir(3) = 1;
val(4) = Qerr - Qm; %reactive power error drops below Qm
dir(4) = -1;
val(5) = Qp - Qerr; %reactive power error rises above Qp
dir(5) = -1;
val(6) = (Qerr - Qm)*(Qp - Qerr); %reactive power error returns to normal
dir(6) = 1;


