function r = dTurbine(t,x,d,z,p)
%p = [Xs Xm Xr Rs Rr ws Jg Tm]
%x = [IsR IsI IrR IrI wr V2R V2I]

Xs = p(1);
Xm = p(2);
Xr = p(3); 
Rs = p(4); 
Rr = p(5); 
ws = p(6); 
Jg = p(7); 
Tm = p(8);

IsR = x(1); 
IsI = x(2);
IrR = x(3);
IrI = x(4);
wr = x(5); 
V2R = x(6); 
V2I = x(7);

V2 = V2R + V2I*1i;
Is = IsR + IsI*1i;
Ir = IrR + IrI*1i;

r = zeros(5,1);
r1 = -V2 + Is*(Rs + Xs*1i) + Ir*1i*Xm;
r2 = Is*1i*Xm + Ir*1i*Xr - Ir*Rr/(wr/ws - 1);
r(1) = real(r1);
r(2) = imag(r1);
r(3) = real(r2);
r(4) = imag(r2);
r(5) = Tm + imag(Is*conj(Is*Xs/ws + Ir*Xm/ws)) - d(5)*Jg;

