function r = dNetwork(t,x,d,z,p)
%r = dNetwork(t,x,d,z,p)
%INPUTS:
%t = current time
%x = current continuous state of this module
%d = current continuous state derivative of this module
%z = current discrete state of this module
%p = parameter vector of this module
%OUTPUTS: 
%r = residue of this module
%COMPOSITION OF PARAMETER AND STATE VECTORS
%p = [X1 X2 Vm Vp ns]
%z = [nT nTq]
%x = [V0R V0I V2R V2I V3R V3I Pd Qd IsR IsI IcR IcI]

%collect parameter and state values and give them names to simplify writing
%residue expressions
X1 = p(1);
X2 = p(2);
n = z(1);

V0R = x(1);
V0I = x(2);
V2R = x(3);
V2I = x(4);
V3R = x(5); 
V3I = x(6); 
Pd = x(7);
Qd = x(8);
IsR = x(9); 
IsI = x(10); 
IcR = x(11); 
IcI = x(12);

%reconstruct complex states to simplify residue expressions
V0 = V0R + V0I*1i;
V2 = V2R + V2I*1i;
V3 = V3R + V3I*1i;
Is = IsR + IsI*1i;
Ic = IcR + IcI*1i;
Z1 = 1i*X1;
Z2 = 1i*X2;
Sd = Pd + Qd*1i;

%initialize residue vector
r = zeros(6,1);

%compute two complex functions that correspond to the module residues
f1 = n*(V0 - n*V2)/Z1 - Is - (Ic + (V2 - V3)/Z2);
f2 = Sd - conj(V2 - V3)/conj(Z2)*V3;

%compute residues
r(1) = real(f1);
r(2) = imag(f1);
r(3) = real(f2);
r(4) = imag(f2);
r(5) = d(1);
r(6) = d(2);



