function r = dCapacitor(t,x,d,z,p)
%p = [C nCT]
%z = [nC nCq]
%x = [IcR IcI V2R V2I]

C = p(1);
n = z(1);

IcR = x(1); 
IcI = x(2);
V2R = x(3); 
V2I = x(4);

V2 = V2R + V2I*1i;
Ic = IcR + IcI*1i;
A = 1i*C*n;

r = zeros(2,1);
r1 = Ic - V2*A;
r(1) = real(r1);
r(2) = imag(r1);
