function [FSA,S,E,Ec,Eo] = UMDES2MATLAB(filename)
%[FSA,S,E,Ec,Eo] = UMDES2MATLAB(filename)
%INPUTS:
%filename = name of file containing the FSA data in UMDES fsm format
%OUTPUTS:
%FSA = FSA cell array 
%S = state names, cell array
%E = cell array of containing all event names
%Ec = cell array containing all controllable event names
%Eo = cell array containing all observable event names

fid = fopen(filename);
ns = str2num(fgetl(fid));
nume = 0;
E = {};
Ec = {};
Eo = {};

for i = 1:ns
    curL = fgetl(fid);
    while strcmp(curL,'')
        curL = fgetl(fid);
    end
    shead = regexp(curL,'\s+','split');
    
    name = shead{1};
    ne = str2num(shead{3});
    events = cell(ne,1);
    ter = cell(ne,1);
    con = zeros(ne,1);
    obs = zeros(ne,1);
    for j = 1:ne
        sevent = regexp(fgetl(fid),'\s+','split');
        events{j,1} = sevent{1};
        
        ter{j,1} = sevent{2};
        if length(sevent) > 2
            con(j) = strcmp(sevent{3},'c');
            obs(j) = strcmp(sevent{4},'o');
        end
        
        if ~sum(strcmp(E,sevent{1}))
            nume = nume + 1;
            E{nume} = sevent{1};
            if strcmp(sevent{3},'c')
                numc = length(Ec);
                Ec{numc + 1} = sevent{1};
            end
            if strcmp(sevent{4},'o')
                numo = length(Eo);
                Eo{numo + 1} = sevent{1};
            end
        end
    end
    S{i} = name;
    FSA(i).events = events;
    FSA(i).ter = ter;
    FSA(i).con = con;
    FSA(i).obs = obs;
end
fclose(fid);

for i = 1:ns
    for j = 1:length(FSA(i).events)
        terN(j,1) = find(strcmp(FSA(i).ter{j},S));
    end
    FSA(i).ter = terN;
end



